
#include <iostream>
#include <cstdio>

class IPlayerInput
{
  public:
    virtual void doStart() = 0;
    virtual void doStop() = 0;
    virtual void doPause() = 0;
};

class IPlayerOutput
{
  public:
    virtual void started() = 0;
    virtual void stopped() = 0;
    virtual void paused() = 0;
};

class IUiInput
{
  public:
    virtual void sayPlay() = 0;
    virtual void sayStop() = 0;
    virtual void sayPause() = 0;
};

class IUiOutput
{
  public:
    virtual void playPause() = 0;
    virtual void stop() = 0;
};

class PlayerControl: public IUiOutput, public IPlayerOutput
{
  public:
    PlayerControl( IPlayerInput *cntrl, IUiInput *ui );
  
    void playPause();
    void stop();

    void started();
    void stopped();
    void paused();
    
  private:
    IPlayerInput  *cntrl;
    IUiInput      *ui;
    
    typedef enum {
      STOP,
      PAUSE,
      PLAY
    } Status;
    
    Status        status = STOP;
};


using namespace std;

void sayPlay()
{
  cout << "play" << endl;
}

void sayStop()
{
  cout << "stop" << endl;
}

void sayPause()
{
  cout << "pause" << endl;
}

typedef enum {
  STOPPED,
  PAUSED,
  STARTED
} PlayerEvent;

extern void doStart(int plFd);
extern void doStop(int plFd);
extern void doPause(int plFd);
extern PlayerEvent getEvent(int plFd);

typedef enum {
  STOP,
  PAUSE,
  PLAY
} Status;

extern int select(int,int);
extern bool changed(int);
extern char getc(int);

void payerControl(int plFd, int uiFd)
{
  Status status = STOP;
  int ret;
  
  while((ret = select(plFd,uiFd)) != -1){
    if(changed(plFd)){
      switch(getEvent(plFd)){
        case STARTED:
          status = PLAY;
          sayPlay();
          break;
        case STOPPED:
          status = STOP;
          sayStop();
          break;
        case PAUSED:
          status = PAUSE;
          sayPause();
          break;
      }
    }
    if(changed(uiFd)){
      switch(getc(uiFd)){
        case 'p':
          switch(status){
            case PAUSED:
              doStart(plFd);
              break;
            case STARTED:
              doPause(plFd);
              break;
          }
          break;
        case 's':
          doStop(plFd);
          break;
      }
    }
  }
  doStop(plFd);
}

int main()
{
  int plFd = setupPlayer();
  int uiFd = fileno(stdin);
  
  payerControl(plFd, uiFd);
  
  return 0;
}

